﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Operators
{
    class Counter
    {
        private readonly int _count;
        private static int _totalCount;

        public Counter()
        {
            _count = 0;
        }

        private Counter(int count)
        {
            _count = count;
        }

        public Counter GetNextValue()
        {
            _totalCount += 1;
            return new Counter(_count + 1);
        }

        public static Counter operator ++(Counter input)
        {
            return input.GetNextValue();
        }

        public int Count
        {
            get
            {
                return _count;
            }
        }

        public static int TotalCount
        {
            get
            {
                return _totalCount;
            }
        }


        // Listing 3-44
        public static Counter operator +(Counter x, Counter y)
        {
            return new Counter(x.Count + y.Count);
        }

        // Listing 3-45
        public static Counter operator +(Counter x, int y)
        {
            return new Counter(x.Count + y);
        }

        public static Counter operator +(int x, Counter y)
        {
            return new Counter(x + y.Count);
        }

        // Listing 3-46
        public static explicit operator int(Counter value)
        {
            return value.Count;
        }

        public static explicit operator Counter(int value)
        {
            return new Counter(value);
        }
    }

    class Example47
    {
        public static void UseExplicitConversion()
        {
            // Listing 3-47
            var c = (Counter) 123;
            var v = (int) c;

            Console.WriteLine(c.Count);
            Console.WriteLine(v);
        }
    }
}
